import java.awt.Color;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

import javax.swing.JFrame;

/**
 * A simple result pad for spirals excercise.
 *
 * @author Barak Naveh
 *
 * @since Dec 19, 2003
 */
public class ResultPad extends JFrame {
    private static final int IMG_SIZE = 500;
    private static final int MARGIN   = 40;
    private Color[][]        m_pixels = new Color[ IMG_SIZE ][ IMG_SIZE ];

    /**
     * Constructor for ResultPad.
     *
     * @throws HeadlessException
     */
    public ResultPad(  ) throws HeadlessException {
        super( "Spirals" );
        setSize( IMG_SIZE + 2 * MARGIN, IMG_SIZE + 3 * MARGIN );
        validate(  );
        setDefaultCloseOperation( EXIT_ON_CLOSE );
    }

    /**
     * Program's entry point.
     *
     * @param args one argument of result file name.
     */
    public static void main( String[] args ) {
        if( args.length != 1 ) {
            System.err.println( "usage: java ResultPad <file-name>" );
            System.exit( 1 );
        }
        else {
            String    fileName = args[ 0 ];
            ResultPad pad = new ResultPad(  );
            pad.readPixelsFromFile( fileName );
            pad.show(  );
        }
    }


    /**
     * @see java.awt.Component#paint(java.awt.Graphics)
     */
    public void paint( Graphics g ) {
        super.paint( g );
        paintContentPane(  );
    }


    private static void drawPixelColor( Graphics g, int x, int y, Color c ) {
        g.setColor( c );
        g.drawLine( x, y, x, y );
    }


    private void init(  ) {
        for( int i = 0; i < IMG_SIZE; i++ ) {
            for( int j = 0; j < IMG_SIZE; j++ ) {
                m_pixels[ i ][ j ] = Color.WHITE;
            }
        }
    }


    private void paintContentPane(  ) {
        Graphics g = getContentPane(  ).getGraphics(  );

        for( int i = 0; i < IMG_SIZE; i++ ) {
            for( int j = 0; j < IMG_SIZE; j++ ) {
                drawPixelColor( g, j + MARGIN, i + MARGIN, m_pixels[ i ][ j ] );
            }
        }
    }


    private void readPixelsFromFile( String fileName ) {
        init(  );

        try {
            BufferedReader in =
                new BufferedReader( new FileReader( fileName ) );
            String         line;

            int            i = 0;

            while( ( line = in.readLine(  ) ) != null && i < IMG_SIZE ) {
                for( int j = 0; j < line.length(  ) && j < IMG_SIZE; j++ ) {
                    if( "Rr".indexOf( line.charAt( j ) ) >= 0 ) {
                        m_pixels[ i ][ j ] = Color.RED;
                    }
                    else if( "Bb".indexOf( line.charAt( j ) ) >= 0 ) {
                        m_pixels[ i ][ j ] = Color.BLUE;
                    }
                }
                i++;
            }
        }
         catch( IOException e ) {
            e.printStackTrace(  );
            throw new RuntimeException( "error reading result file" );
        }
    }
}
